import { generateHash } from "@/lib/hash";
import { expect, test } from 'vitest'

test('generates same hash for like entries with ignored properties', () => {
    const input = generateTestData_DifferentHashes_ButIgnored()

    for (const i of input) {
        for (const d of i.data) {

            const firstResult = generateHash(d.first, { ignore: i.given });
            const secondResult = generateHash(d.second, { ignore: i.given });
            expect(firstResult).toBe(secondResult)
        }
    }
})

test('generates different hash for unlike entries', () => {
    const testData = generateTestData_DifferentHashes()

    for (const d of testData) {
        const firstResult = generateHash(d.first);
        const secondResult = generateHash(d.second);
        expect(firstResult).not.toBe(secondResult)
    }
})

test('generates same hash for like entries', () => {
    const testData = generateTestData_SameHashes()

    for (const d of testData) {
        const firstResult = generateHash(d.first);
        const secondResult = generateHash(d.second);
        expect(firstResult).toBe(secondResult)
    }
})

function generateTestData_SameHashes() {
    return [
        {
            first: "random string",
            second: "random string",
        },
        {
            first: 1,
            second: 1,
        },
        {
            first: { same: 'value' },
            second: { same: 'value' },
        },
        {
            first: { same: 'response', different: 'order' },
            second: { different: 'order', same: 'response' },
        },
        {
            first: null,
            second: null,
        },
        {
            first: undefined,
            second: undefined,
        },
        {
            first: ["1", 2],
            second: ["1", 2],
        },
    ] satisfies {
        first: unknown,
        second: unknown,
    }[]
}

function generateTestData_DifferentHashes() {
    return [
        {
            first: "random string",
            second: "some other string",
        },
        {
            first: 1,
            second: "1",
        },
        {
            first: { different: 'response' },
            second: { different: 'order' },
        },
        {
            first: 2,
            second: null,
        },
        {
            first: undefined,
            second: null,
        },
        {
            first: [2, "1"],
            second: ["1", 2],
        },
    ] satisfies {
        first: unknown,
        second: unknown,
    }[]
}

function generateTestData_DifferentHashes_ButIgnored() {
    return [
        {
            given: ["different"] satisfies string[],
            data: [
                {
                    first: { different: 'response', diff: { different: 'response' } },
                    second: { different: 'order', diff: { different: 'order'} },
                },
                {
                    first: { different: 'response' },
                    second: { different: 'order' },
                },
                {
                    first: { different: 'response', but: 'same' },
                    second: { different: 'answer', but: 'same' },
                },
                {
                    first: { same: 'response' },
                    second: { same: 'response' },
                },
            ]
        }
    ] satisfies {
        given: string[], data: {
            first: unknown,
            second: unknown,
        }[]
    }[]

}